### Script Phylogenetic logistic regression
#
#
setwd("C:/")
###PACKAGES
install.packages(c('phytools','remotes','textshape'))
library(phytools)
library(textshape)
library(remotes)
remotes::install_github('lamho86/phylolm')
library(phylolm)
install.packages(library(ROCit))
library(ROCit)

# Phylogeny with a nexus file
tre <- read.nexus(file=file.choose())
plot(tre)
# Data
dat <- read.table(file=file.choose(), header=T, stringsAsFactor=F)
dat
setdiff(dat$species, tre$tip.label)

dat<-column_to_rownames(dat, loc=1)
dat

#Analyses
rst<-phyloglm(Thermo ~ Can_harmean, data=dat, phy=tre, method='logistic_IG10')
summary(rst)
mean(rst$fitted.values) # to obtain the cutoff probability (p=0.59).
confint(rst)
rst2<-glm(Thermo ~ Can_harmean, data=dat, family=binomial)
summary(rst2)

#Estimation of the model quality

thermo_true<-dat$Thermo[is.na(dat$Thermo)==F]
thermo_true
prob<-fitted.values(rst)
prob
plot(prob ~ dat$Can_harmean)

thermo_predict<-as.numeric(prob>0.5)
thermo_predict
#contingency table. Rows: predictions; columns: true values
table(thermo_predict,thermo_true)
#specificity calculation
Sp=28/(28+1)
print(Sp)
#Sp=0.9655172
#sensitivity calculation
Se=14/(14+3)
print(Se)
#Se=0.8235294
#classification error calculation

error1=(1+3)/(14+1+3+28)
error1
#error1=0.08695652

#ROC curve
courbe_roc<-rocit(score=prob,class=thermo_true)
Roc_plot=plot(courbe_roc,values=T)
#discrimination rate
print(Roc_plot$AUC)

tau_opt<-Roc_plot[[6]][4]
tau_opt
#cutoff=0.6272719
#second prediction
thermo_predict2<-as.numeric(prob>tau_opt)
table(thermo_predict2,thermo_true)
#classification error calculation
error2=(3+2)/(15+3+2+26)
error2
# error2: 0.1086957 
# error2>error1
# Error rate increased for this second cutoff probability estimation
# used cutoff : 0.59

